<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Grid Format - A topics based format that uses a grid of user selectable images to popup a light box of the section.
 *
 * @package    format_grid
 * @version    See the value of '$plugin->version' in version.php.
 * @copyright  &copy; 2013 G J Barnard in respect to modifications of standard topics format.
 * @author     G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 * @author     Based on code originally written by Paul Krix and Julian Ridden.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


// CONTRIB-4099 Image container size change improvement.
$string['defaultbordercolour'] = 'Default image container border color';
$string['defaultbordercolour_desc'] = 'The default image container border color.';
$string['defaultimagecontainerbackgroundcolour'] = 'Default image container background color';
$string['defaultimagecontainerbackgroundcolour_desc'] = 'The default image container background color.';
$string['defaultcurrentselectedsectioncolour'] = 'Default current selected section color';
$string['defaultcurrentselectedsectioncolour_desc'] = 'The default current selected section color.';
$string['defaultcurrentselectedimagecontainertextcolour'] = 'Default current selected image container text color';
$string['defaultcurrentselectedimagecontainertextcolour_desc'] = 'The default current selected image container text color.';
$string['defaultcurrentselectedimagecontainercolour'] = 'Default current selected image container color';
$string['defaultcurrentselectedimagecontainercolour_desc'] = 'The default current selected image container color.';

$string['setimagecontaineralignment_help'] = 'Set the image container width to one of: Left, Center or Right';
$string['setbordercolour'] = 'Set the border color';
$string['setbordercolour_help'] = 'Set the border color in hexidecimal RGB.';
$string['setimagecontainerbackgroundcolour'] = 'Set the image container background color';
$string['setimagecontainerbackgroundcolour_help'] = 'Set the image container background color in hexidecimal RGB.';
$string['setcurrentselectedsectioncolour'] = 'Set the current selected section color';
$string['setcurrentselectedsectioncolour_help'] = 'Set the current selected section color in hexidecimal RGB.';
$string['setcurrentselectedimagecontainertextcolour'] = 'Set the current selected image container text color';
$string['setcurrentselectedimagecontainertextcolour_help'] = 'Set the current selected image container text color in hexidecimal RGB.';
$string['setcurrentselectedimagecontainercolour'] = 'Set the current selected image container color';
$string['setcurrentselectedimagecontainercolour_help'] = 'Set the current selected image container color in hexidecimal RGB.';
$string['sectiontitlesummarytextcolour'] = 'Set the section title summary text color on hover';
$string['sectiontitlesummarytextcolour_help'] = 'Set the the section title summary text color when hovering over the section title in the grid box.';
$string['defaultsectiontitlesummarytextcolour'] = 'Set the section title summary text color on hover';
$string['defaultsectiontitlesummarytextcolour_desc'] = 'Set the the section title summary text color when hovering over the section title in the grid box.';
$string['sectiontitlesummarybackgroundcolour'] = 'Set the section title summary background color on hover';
$string['sectiontitlesummarybackgroundcolour_help'] = 'Set the the section title summary background color when hovering over the section title in the grid box.';
$string['defaultsectiontitlesummarybackgroundcolour'] = 'Set the section title summary background color on hover';
$string['defaultsectiontitlesummarybackgroundcolour_desc'] = 'Set the the section title summary background color when hovering over the section title in the grid box.';
$string['centre'] = 'Center';

$string['colourrule'] = "Please enter a valid RGB color, six hexadecimal digits.";

// Section title text format options.
$string['sectiontitleinsidetitletextcolour'] = 'Section title text color when \'Inside\' option';
$string['sectiontitleinsidetitletextcolour_help'] = 'Set title text color when it is \'Inside\' the grid box.';
$string['defaultsectiontitleinsidetitletextcolour'] = 'Section title text color when \'Inside\' option';
$string['defaultsectiontitleinsidetitletextcolour_help'] = 'Set title text color when it is \'Inside\' the grid box.';
$string['sectiontitleinsidetitlebackgroundcolour'] = 'Section title background color when \'Inside\' option';
$string['sectiontitleinsidetitlebackgroundcolour_help'] = 'Set title background color when it is \'Inside\' the grid box.';
$string['defaultsectiontitleinsidetitlebackgroundcolour'] = 'Section title background color when \'Inside\' option';
$string['defaultsectiontitleinsidetitlebackgroundcolour_help'] = 'Set title background color when it is \'Inside\' the grid box.';
$string['sectiontitlealignment_help'] = 'Set the section title alignment to one of \'Left\', \'Center\' or \'Right\'.';
$string['defaultsectiontitlealignment_desc'] = 'Set the section title alignment to one of \'Left\', \'Center\' or \'Right\'.';

// Reset.
$string['resetgreyouthidden'] = 'Gray out unavailable';
$string['resetgreyouthidden_desc'] = 'Resets the property \'Grid display show unavailable section images in gray and unlinked.\'';
$string['resetgreyouthidden_help'] = 'Resets the property \'In Grid display show unavailable section images in gray and unlinked.\'';

// Other.
$string['greyouthidden'] = 'Gray out unavailable';
$string['greyouthidden_desc'] = 'In Grid display show unavailable section images in gray and unlinked.';
$string['greyouthidden_help'] = 'In Grid display show unavailable section images in gray and unlinked.';
