# Moodle Multitopic Format ⭐


> Shows multiple topics per page, with tabbed navigation between pages.  Topics are collapsible, and can optionally be timed.

### 🏠 [Otago Polytechnic](https://op.ac.nz)


## Install

1. Copy files to moodle/course/format/multitopic.
2. Log in as an admin, and visit moodle/admin/index.php, to update plugin data.
3. Site administration > Appearance > Additional HTML > Within HEAD (or other location appropriate for CSS): Copy and paste styles from README_styles.css (customising appropriately).
4. Site administration > Appearance > Themes > Theme settings > Allow category themes: Yes (if you want categories to have custom CSS).


## Features

* Tabbed pages (like Onetopic format)
* Multiple topics per page (a bit like Flexible Sections format)
* Collapsible topics (like Collapsed Topics format)
* Optionally timed topics (a bit like Periods format)
* Course banner image (like Snap theme)
* Section images (a bit like Grid format)


## Author

👤 **James Calder**

* Github: [@james-cnz](https://github.com/james-cnz)


## Docs

🚀 [Roadmap](docs/roadmap.md)
📄 [Contributing](docs/contributing.md)


## Acknowledgements

The Multitopic format is based on ideas from several other course formats, and notably includes code copied from:

* Onetopic format by David Herney Bernal García (including code for displaying tabs, disabling asychronous editing, and managing settings)
* Periods format by Marina Glancy (code for managing settings)
